unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, DBGrids, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    DBGrid1: TDBGrid;
    Query1: TQuery;
    DataSource1: TDataSource;
    ComboBox1: TComboBox;
    btnVegrehajtas: TButton;
    btnSelect: TButton;
    btnInsert: TButton;
    btnDelete: TButton;
    btUpdate: TButton;
    edtFileSize: TEdit;
    RadioGroup1: TRadioGroup;
    Label1: TLabel;
    btnInsertSelect: TButton;
    btnCreateTable: TButton;
    btnAlterTable: TButton;
    btnCreateIndex: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnVegrehajtasClick(Sender: TObject);
    procedure btnSelectClick(Sender: TObject);
    procedure btnInsertClick(Sender: TObject);
    procedure btnSaveQueryStringClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnDeleteClick(Sender: TObject);
    procedure btUpdateClick(Sender: TObject);
    procedure edtFileSizeKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnInsertSelectClick(Sender: TObject);
    procedure btnCreateTableClick(Sender: TObject);
    procedure btnAlterTableClick(Sender: TObject);
    procedure btnCreateIndexClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBox1.Items.LoadFromFile('queries.sql');
  ComboBox1.Text :='Select * From Program';
end;

procedure TForm1.btnVegrehajtasClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add(ComboBox1.Text);
    Open;     // vagy ExecSQL - ha nincs szksg az eredmnyre
              // (ltalban mindig, ha az utasts nem SELECT)
  end;

 with ComboBox1 do
  if Pos(UpperCase(Text), UpperCase(Items.Text))=0
    then Items.Add(Text);
end;

procedure TForm1.btnSelectClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add(btnSelect.Caption + ' ' + RadioGroup1.Items[RadioGroup1.ItemIndex]);
    SQL.Add(' :fsize ORDER BY filename');
    ParamByName('fsize').AsInteger:=StrToInt(edtFileSize.Text);
    Open;
  end;
end;

procedure TForm1.btnInsertClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add('Insert Into program (folder, filename, filesize, filedate, notes)'+
            'Values ("delph2","sqlprog.exe",635948,Cast("03.05.2000." AS Date),"Hello")');
    ExecSQL;
  end;
end;

procedure TForm1.btnSaveQueryStringClick(Sender: TObject);
begin
  ComboBox1.Items.Add(ComboBox1.Text);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ComboBox1.Items.SaveToFile('queries.sql');
end;

procedure TForm1.btnDeleteClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add('delete from program where filename="sqlprog.exe"') ;
    ExecSQL;
  end;
end;

procedure TForm1.btUpdateClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add('Update program Set filesize=1111, '+
            'filedate=Cast("10.09.2000." AS Date) ' +
            'where filename="sqlprog.exe" ') ;
    ExecSQL;
  end;
end;

procedure TForm1.edtFileSizeKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key >= Ord('A')
   then edtFileSize.Text:='1000';
end;
                                            
procedure TForm1.btnInsertSelectClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add('Insert Into program '+
            'SELECT * FROM program1 WHERE program1.filename LIKE "sql%.exe"');
    ExecSQL;
  end;
end;

procedure TForm1.btnCreateTableClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
   SQL.Add('CREATE TABLE "empl.dbf" '+
	'(LAST_NAME CHAR(20), FIRST_NAME CHAR(15), SALARY NUMERIC(10,2), DEPT_NO SMALLINT)');
    ExecSQL;
  end;
end;

procedure TForm1.btnAlterTableClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add('ALTER TABLE "empl.dbf" DROP LAST_NAME, DROP FIRST_NAME, ADD FULL_NAME CHAR[30]');

    ExecSQL;
  end;
end;

procedure TForm1.btnCreateIndexClick(Sender: TObject);
begin
 with Query1 do
  begin
    Close;
    SQL.Clear;
    SQL.Add('CREATE INDEX NAME_X ON "empl.dbf" (LAST_NAME)');

    ExecSQL;
  end;
end;

end.
